<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discipline extends Model 
{

    protected $table = 'disciplines';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'slug', 'gender');

    public function athletes()
    {
        return $this->belongsToMany('App\Models\Athlete');
    }

    public function trainers()
    {
        return $this->belongsToMany('App\Models\Trainer');
    }

}